package easik.ui.menu.popup;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.constraint.Constraint;
import easik.sketch.edge.SketchEdge;
import easik.sketch.vertex.EntityNode;


/**
 * Action used by the Delete menu option.
 * 
 * @author Rob Fletcher 2005
 */
public class DeleteAction extends AbstractAction {
	
	/**
	 * The delete button gets initialized
	 *
	 */
	public DeleteAction() {
		super("Delete");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Delete an Entity, Edge, or Constraint");
	}

	/**
	 * When the action is performed, selection is deleted if possible.  Error is displayed 
	 * if no graph item is selected.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		int op = JOptionPane.showConfirmDialog(Easik.getInstance().getFrame(), "Are you sure you want to delete the selected items?", "Confirm Deletion", JOptionPane.YES_NO_OPTION);
		if(op == JOptionPane.YES_OPTION){
			Vector currentSelection =
				Easik
					.getInstance()
					.getFrame()
					.getSketch()
					.getSelectionListener()
					.getCurrentSelection();
	
			if (currentSelection.size() == 0) {
				JOptionPane.showMessageDialog(
					Easik.getInstance().getFrame(),
					"Operation must be performed with something selected",
					"Error",
					JOptionPane.ERROR_MESSAGE);
			} else {
				for (int i = 0; i < currentSelection.size(); i++) {
					if (currentSelection.get(i) instanceof Constraint) {
						Easik
							.getInstance()
							.getFrame()
							.getSketch()
							.removeConstraint(
							(Constraint) currentSelection.get(i));
					} else if (currentSelection.get(i) instanceof EntityNode) {
						Easik.getInstance().getFrame().getSketch().removeEntity(
							(EntityNode) currentSelection.get(i));
					} else if (currentSelection.get(i) instanceof SketchEdge) {
						Easik.getInstance().getFrame().getSketch().removeEdge(
							(SketchEdge) currentSelection.get(i));
					}
				}
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}
	
			// Clear selection after things have been deleted		
			Easik
				.getInstance()
				.getFrame()
				.getSketch()
				.getSelectionListener()
				.emptySelection();
		}
	}

}
